<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Bpatrak extends CI_Controller {
  

  public function __construct() {
    parent::__construct();
     $this->load->library('Excel');
    $this->load->model("Bpatrak_model");
  }


  public function index()
  {   

    $breadcrumbs="<ol class='breadcrumb'>
       <li><a href='".site_url('Dashboard')."'><i class='ace-icon fa fa-home home-icon'></i>Dashboard</a></li>
       <li class='active'>Incidence Spot</li>
       </ol>";

          $data=array(
            'breadcrumbs' =>$breadcrumbs,
            'actioncolumn' => '6',
            'heading' => 'Incidence Spot',
            'ajax_manage_page' => site_url('Bpatrak/ajax_manage_page'),
          );
          $this->load->view('bpatrak/list',$data);
  }


  public function ajax_manage_page() {
    if($_SESSION[SESSION_NAME]['type']=='Station_Head'){
       $row = $this->Crud_model->GetData("mst_police",'police_station_id',"id='".$_SESSION[SESSION_NAME]['id']."'","","","","1");
      $condition = "b.police_station_id='".$row->police_station_id."'";
      
    }else if($_SESSION[SESSION_NAME]['type']=='Head_Person'){
       $row = $this->Crud_model->GetData("mst_police",'city_id',"id='".$_SESSION[SESSION_NAME]['id']."'","","","","1");
      $condition = "b.city_id='".$row->city_id."'";
      
    }else{

    $condition = "1=1";
    }
    $getData = $this->Bpatrak_model->get_datatables($condition);

    $data = array();

    if(empty($_POST['start'])) {
      $no = 0;   
    } else {
      $no = $_POST['start'];
    }
    
    foreach ($getData as $Data) {

      $viewUrl = "Bpatrak/view";
      $btn ='<span class="action-buttons"><a title="View" href="'.site_url($viewUrl.'/'.base64_encode($Data->id)).'" class="btn btn-primary btn-circle btn-xs"><i class="ace-icon fa fa-eye bigger-130"></i></a></span>';

      $no++;  
      $nestedData = array();
      $nestedData[] = $no;
      $nestedData[] = ucfirst($Data->fir_number);
      $nestedData[] = $Data->complaint_title;
      $nestedData[] = $Data->criminal_name;
      $nestedData[] = $Data->arrested_datetime;
      $nestedData[] = $Data->crime_datetime;
      $nestedData[] = $Data->fir_datetime;
      $nestedData[] = $btn;
      $data[] = $nestedData;
      $selected = '';
    }

    $output = array(
      "draw" => $_POST['draw'],
      "recordsTotal" => $this->Bpatrak_model->count_all($condition),
      "recordsFiltered" => $this->Bpatrak_model->count_filtered($condition),
      "data" => $data,
    );
    echo json_encode($output);
  }

  public function view($id)
  {
    $id = base64_decode($id);
    $row = $this->Crud_model->GetData("bpatrak",'',"id='".$id."'","","","","1");
    
    $breadcrumbs='<ul class="breadcrumb">
                    <li>
                    <i class="ace-icon fa fa-home home-icon"></i>
                    <a href="'.site_url('Dashboard/index').'">Dashboard</a>
                    </li>
                    <li><a href="'.site_url('Bpatrak/index').'">Manage Incidence Spot</a></li>
                    <li class="active">Incidence Spot Details</li>
                  </ul>';

    if(!empty($row))
    {
      $data = array(
        "breadcrumbs"=>$breadcrumbs,
        "cancelbtn"=>site_url('Bpatrak'),
        "fir_number"=>$row->fir_number,
        "complaint_title"=>$row->complaint_title,
        "criminal_name"=>$row->criminal_name,
        "arrested_datetime"=>$row->arrested_datetime,
        "crime_datetime"=>$row->crime_datetime,
        "fir_datetime"=>$row->fir_datetime,
        "lost_things"=>$row->lost_things,
        "found_things"=>$row->found_things,
        "crime_place"=>$row->crime_place,
        "incident_name"=>$row->incident_name,
        "victim_mobile_number"=>$row->victim_mobile_number,
        "reality"=>$row->reality,
        "police_id"=>$row->police_id,
        "police_station_head_id"=>$row->police_station_head_id,
        "image"=>$row->image,
        "video"=>$row->video,
      );
      $this->load->view('bpatrak/view', $data);
    }   
    else 
    {
      $this->session->set_flashdata('message', 'Record Not Found');
      redirect('Bpatrak/index');
    }         
  }

  public function export() {

        $filename = 'incidenceSpot_'.date('Ymd').'.csv'; 

         header("Content-Description: File Transfer"); 
         header("Content-Disposition: attachment; filename=$filename"); 
         header("Content-Type: application/csv; ");
        
        // get data
        $bpatrakData = $this->Bpatrak_model->getBpatrakData();
        //echo "<pre>";print_r($bpatrakData);exit(); 
        //echo "hey";exit(); 

        // file creation 
        $file = fopen('php://output','w');
        $header = array("Sr.No","State","District","City","FIR Number","Complaint Title","Criminal Name","Arrested Date","Crime Date","FIR Date","Address"); 
        fputcsv($file, $header);
        $sr=1;
       
        foreach ($bpatrakData as $i=>$line){ 
            $keys['sr_no'] = $sr;
            $keys['state_name'] = strtoupper($line->state_name); 
            $keys['district_name'] = strtoupper($line->district_name);
            $keys['city_name'] = strtoupper($line->city_name);
            $keys['fir_number'] = strtoupper($line->fir_number);
            $keys['complaint_title'] = strtoupper($line->complaint_title);
            $keys['criminal_name'] = strtoupper($line->criminal_name);
            $keys['arrested_datetime'] = date('Y-m-d', strtotime($line->arrested_datetime));
            $keys['crime_datetime'] = date('Y-m-d', strtotime($line->crime_datetime));
            $keys['fir_datetime'] = date('Y-m-d', strtotime($line->fir_datetime));
            $keys['address'] = strtoupper($line->address);
            
          fputcsv($file,$keys); 
          $sr++;
        }
        fclose($file); 
        exit; 
    }


  public function import()
  {
    $file = $_FILES['excel_file']['tmp_name'];
    $this->load->library('excel');
    //read file from path
    $objPHPExcel = PHPExcel_IOFactory::load($file);
    $allDataInSheet = $objPHPExcel->getActiveSheet()->toArray(null,true);

    $arrayCount = count($allDataInSheet);
    $i = 3;

    foreach ($allDataInSheet as $val) 
    {
      if ($i <= 3) 
      {

      }
      else
      {
         $fields_fun[] = $val;
      }
      $i++;
    }
    $removed = array_shift($fields_fun);

    if(!isset($fields_fun))
    {
      $this->session->set_flashdata('message', '<span class="label label-danger text-center" style="margin-bottom:0px">Excel Sheet is blank</span>');
      redirect(site_url('Bpatrak/index'));            
    } 
    $data = $fields_fun;
    //echo "<pre>"; print_r($data); die();
    $exists = 0;
    foreach ($data as $val) 
    {  
      if($val[0] !='' && $val[1] !='' && $val[2] !='' && $val[3] !='' && $val[4] !='' && $val[5] !='' && $val[6] !='' && $val[7] !='' && $val[8] !='' && $val[9])
      { 
         $getBpatrak = $this->Crud_model->GetData('bpatrak','fir_number',"fir_number='".trim($val[3])."'",'','','','single'); 

         $states = $this->Crud_model->GetData('mst_states','id',"state_name='".$val[0]."'",'','','','single'); 

         $districts = $this->Crud_model->GetData('mst_districts','id',"district_name='".$val[1]."'",'','','','single'); 

         $cities = $this->Crud_model->GetData('mst_cities','id',"city_name='".$val[2]."'",'','','','single');
     

         /*for already exist check*/

         if(empty($getBpatrak))
         {
            if(!empty($val[9]))
            {
               $address=$val[9];
            } 
            else
            {
               $address="";
            }

            if(!empty($val[8]))
            {
               $fir_datetime=$val[8];
            } 
            else
            {
               $fir_datetime="";
            }

            if(!empty($val[7]))
            {
               $crime_datetime=$val[7];
            } 
            else
            {
               $crime_datetime="";
            }

            if(!empty($val[6]))
            {
               $arrested_datetime=$val[6];
            } 
            else
            {
               $arrested_datetime="";
            }

            if(!empty($val[5]))
            {
               $criminal_name=$val[5];
            } 
            else
            {
               $criminal_name="";
            }

            if(!empty($val[4]))
            {
               $complaint_title=$val[4];
            } 
            else
            {
               $complaint_title="";
            }

            if(!empty($val[3]))
            {
               $fir_number=$val[3];
            } 
            else
            {
               $fir_number="";
            }

            if(!empty($cities))
            {
               $city_id=$cities->id;
            } 
            else
            {
               $city_id="";
            }

            if(!empty($districts))
            {
               $district_id=$districts->id;
            } 
            else
            {
               $district_id="";
            }

            if(!empty($states))
            {
               $state_id=$states->id;
            } 
            else
            {
               $state_id="";
            }

            $data = array(
               'country_id' => "101",
               'state_id' => $state_id,
               'district_id' => $district_id,
               'city_id' => $city_id,
               'fir_number' => trim($fir_number),
               'complaint_title' => trim($complaint_title),
               'criminal_name' => trim($criminal_name),
               'arrested_datetime' => $arrested_datetime,
               'crime_datetime' => $crime_datetime,
               'fir_datetime' => $fir_datetime,
               'address' => $address,
            );
            $SaveAssets = $this->Crud_model->SaveData('bpatrak',$data);
         }
         else
         { 
            $existAssets[]=array($val[0],$val[1],$val[2],$val[3],$val[4],$val[5],$val[6],$val[7],$val[8],$val[9],'Already exist');
         }

      }
      else
      {
         $existAssets[]=array($val[0],$val[1],$val[2],$val[3],$val[4],$val[5],$val[6],$val[7],$val[8],$val[9],'Mandatory fields empty');
      }
   }
    if(empty($existAssets))
   {
      $this->session->set_flashdata('message', '<span class="label label-success text-center" style="margin-bottom:0px">Record has been imported successfully</span>');
      redirect('Bpatrak/index');
   }
   else
   {
      $data = array('existAssets' => $existAssets);
      $this->load->view('bpatrak/duplicateBpatrak',$data);
   } 
  }

}
